import React from 'react';
import {ClassName} from 'bem-cn-lite';
import {Moment} from 'moment';

import commonKeyset from '../../../../i18n/common';
import {HUMAN_SHORT, TIME} from '../../../../lib/date/formats';

interface ITableTimeProps {
    b: ClassName;
    timeMoment: Moment;
    showDate: boolean;
    isFuzzy: boolean;
}

const TableTime: React.FC<ITableTimeProps> = ({
    b,
    timeMoment,
    showDate,
    isFuzzy,
}) => {
    const isValid = timeMoment.isValid();

    return (
        <div className={b('dateTime')}>
            {showDate && isValid && (
                <div className={b('date')} data-nosnippet>
                    {timeMoment.format(HUMAN_SHORT)}
                </div>
            )}

            <span className={b('time', {isFuzzy})}>
                {isValid ? timeMoment.format(TIME) : commonKeyset('no-data')}
            </span>
        </div>
    );
};

export default TableTime;
