import get from 'lodash/get';
import omit from 'lodash/omit';

import ISegment from 'common/interfaces/segment/ISegment';
import ISegmentBadges from 'common/interfaces/segment/ISegmentBadges';
import ITransferSegment from 'common/interfaces/transfer/ITransferSegment';

import gatherMinPriceData from '../../../lib/segments/gatherMinPriceData';

/**
 * Вернет бейджики для отображения с учетом фильтров.
 * Важно в случае, когда из-за фильтров в сегменте пропадает самый дешевый класс,
 * но сегмент глобально по факту остается самым дешевым без учета фильтров
 * @param {Object} segment - сегмент
 * @return актуальные бейджики для отображения
 */
export function getActualBadgesToDisplayAfterFiltering(
    segment: ISegment | ITransferSegment,
): ISegmentBadges | undefined {
    const {badges} = segment;

    if (!badges) {
        return;
    }

    const {cheapest} = badges;

    if (!cheapest) {
        return badges;
    }

    const minPriceData = gatherMinPriceData([segment]);
    const cheapestClass = get(minPriceData, 'price.class');

    if (!segment.tariffClassKeys.includes(cheapestClass)) {
        return omit(badges, ['cheapest']);
    }

    return badges;
}
