import {momentTimezone as moment} from '../../../../reexports';

import {isRangeArrival} from './isRangeArrival';

/**
 * Вернёт минимальное время в пути для сегмента
 * @param {data} segment - данные сегмента
 * @return {number}
 */
export function getDuration(segment) {
    const {stationTo, minArrival, arrivalMoment, departureMoment} = segment;
    const arrival = isRangeArrival(segment)
        ? moment.tz(minArrival, stationTo.timezone)
        : arrivalMoment;

    return arrival.diff(departureMoment, 'seconds');
}
