import React, {ReactNode} from 'react';
import B from 'bem-cn-lite';

import {EBannerType} from '../../../common/interfaces/state/search/BannerInfo';

import SearchSegmentsBase from './SearchSegments.base';
import RidesharingSegment from '../RidesharingSegment';
import FilterGone from '../FilterGone/FilterGone.desktop';
import SearchSegment from '../SearchSegment/SearchSegment.desktop';
import DatesSeparator from '../DatesSeparator/DatesSeparator.desktop';
import SearchTransfer from '../SearchTransfer/SearchTransfer.desktop';
import SearchMetaSegment from '../SearchMetaSegment/SearchMetaSegment.desktop';
import SearchSegmentsDirect from './components/SearchSegmentsDirect/SearchSegmentsDirect';
import TravelHotelsBanner from '../TravelHotelsBanner/TravelHotelsBanner.desktop';

import keyset from '../../i18n/table-search-header';

const b = B('SearchSegments');

export default class DesktopSearchSegments extends SearchSegmentsBase {
    getSearchSegment(data): ReactNode {
        const {segment} = data;
        let SegmentComponent:
            | typeof SearchSegment
            | typeof SearchTransfer
            | typeof SearchMetaSegment = SearchSegment;

        if (segment.isTransfer) {
            SegmentComponent = SearchTransfer;
        } else if (segment.isMetaSegment) {
            SegmentComponent = SearchMetaSegment;
        }

        return (
            <SegmentComponent
                key={segment.segmentId}
                data={data}
                className={b('segment')}
            />
        );
    }

    getDirectSnippet(index): ReactNode {
        const {context, transportTypes} = this.props;

        return (
            <tr className={b('row', {gap: true})} key={`direct-${index}`}>
                <td className={b('column')}>
                    <SearchSegmentsDirect
                        index={index}
                        context={context}
                        transportTypes={transportTypes}
                    />
                </td>
            </tr>
        );
    }

    getGoneFilter(): ReactNode {
        const {filtering, archivalData} = this.props;

        if (archivalData || !filtering.filters?.gone?.activeOptions) {
            return null;
        }

        return (
            <tr className={b('row', {gap: true})} key="goneFilter">
                <td className={b('column')}>
                    <FilterGone {...filtering.filters.gone} />
                </td>
            </tr>
        );
    }

    getDatesSeparator({segment}, insertIndex): ReactNode {
        const {context, sort} = this.props;

        if (!context.from.timezone) {
            return null;
        }

        return (
            <tr className={b('row')} key={`date-${insertIndex}`}>
                <td className={b('column')}>
                    <DatesSeparator
                        date={segment.departure}
                        endOfDay={sort.reverse}
                        timezone={context.from.timezone}
                    />
                </td>
            </tr>
        );
    }

    getBanner(insertIndex): ReactNode {
        const {blablacar, language, flags, bannerInfo} = this.props;

        switch (bannerInfo?.bannerType) {
            case EBannerType.YA_TRAVEL_HOTELS:
                return (
                    <tr className={b('row')} key="hotelsBanner">
                        <td className={b('column')}>
                            <TravelHotelsBanner
                                className={b('banner')}
                                bannerInfo={bannerInfo}
                            />
                        </td>
                    </tr>
                );
            case EBannerType.BLA_BLA_CAR:
                return (
                    <tr className={b('row')} key={`bbc-${insertIndex}`}>
                        <td className={b('column')}>
                            <RidesharingSegment
                                className={b('blablacar')}
                                {...blablacar}
                                language={language}
                                flags={flags}
                            />
                        </td>
                    </tr>
                );
            case EBannerType.ADVERTISING:
                return this.getDirectSnippet(-1);

            default:
                return null;
        }
    }

    render(): ReactNode {
        return (
            <table className={b()}>
                <thead className={b('header')}>
                    <tr>
                        <th>{keyset('route')}</th>
                        <th>{keyset('departure')}</th>
                        <th>{keyset('arrival')}</th>
                        <th>{keyset('duration')}</th>
                        <th>{keyset('days')}</th>
                        <th>{keyset('price')}</th>
                        <th>{keyset('arrivalDepartureStations')}</th>
                        <th>{keyset('company')}</th>
                    </tr>
                </thead>

                <tbody className={b('tbody')}>
                    {this.getRenderMap().map(snippet =>
                        snippet.componentBuilder
                            ? snippet.componentBuilder(snippet.data)
                            : snippet,
                    )}
                </tbody>
            </table>
        );
    }
}
