import React, {memo, useState, useMemo, useCallback} from 'react';
import {useInView} from 'react-intersection-observer';
import B from 'bem-cn-lite';

import Platform from '../../../../interfaces/Platform';
import {TransportType} from '../../../../lib/transportType';
import AdFoxType from '../../../../interfaces/components/adFox/AdFoxType';
import ISearchContext from '../../../../interfaces/state/search/ISearchContext';
import AdFoxPosition from '../../../../interfaces/components/adFox/AdFoxPosition';

import AdFoxBanner from '../../../AdFoxBanner/AdFoxBanner';
import DirectSnippet from './components/DirectSnippet/DirectSnippet';

const b = B('SearchSegmentsDirect');

interface ISearchSegmentsDirectParams {
    index: number;
    context: ISearchContext;
    transportTypes: TransportType[];
}

const isMobile = process.env.PLATFORM === Platform.mobile;

const ADFOX_POSITION = -1;

export default memo(SearchSegmentsDirect);

function SearchSegmentsDirect({
    index,
}: ISearchSegmentsDirectParams): React.ReactElement {
    const [adfoxNotHaveError, setAdfoxNotHaveError] = useState(true);
    const [ref, wasSeen] = useInView({
        triggerOnce: true,
        rootMargin: '500px',
    });

    const onAdFoxError = useCallback(() => {
        setAdfoxNotHaveError(false);
    }, []);

    const direct = useMemo(() => {
        if (!wasSeen) {
            return null;
        }

        return <DirectSnippet className={b('snippet', {direct: true})} />;
    }, [wasSeen]);

    return (
        <div className={b({isMobile, isDesktop: !isMobile})} ref={ref}>
            {adfoxNotHaveError && index === ADFOX_POSITION ? (
                <AdFoxBanner
                    position={AdFoxPosition.center}
                    type={AdFoxType.inline}
                    onError={onAdFoxError}
                    className={b('snippet', {adfox: true})}
                />
            ) : (
                direct
            )}
        </div>
    );
}
