import React from 'react';

import Platform from '../../../../../../interfaces/Platform';
import {IWithClassName} from '../../../../../../interfaces/components/IWithClassName';

import {useDirectSnippetId} from './utilities/useDirectSnippetId';

import Direct from '../../../../../Direct/Direct';

const isMobile = process.env.PLATFORM === Platform.mobile;
const BLOCK_ID = isMobile ? 'R-I-239082-132' : 'R-I-94177-59';

interface IDirectSnippetProps extends IWithClassName {}

const DirectSnippet: React.FC<IDirectSnippetProps> = props => {
    const blockId = useDirectSnippetId(isMobile) || BLOCK_ID;

    return (
        <div className={props.className}>
            <Direct blockId={blockId} />
        </div>
    );
};

export default DirectSnippet;
