import React from 'react';

import IStateFlags from 'common/interfaces/state/flags/IStateFlags';
import {IWithClassName} from 'common/interfaces/components/IWithClassName';

import RecommendationWidget from '../../../../../RecomendationWidget/RecommendationWidget';

interface IRecommendationSnippetProps extends IWithClassName {
    flags: IStateFlags;
}

const SNIPPET_WIDGET_ID = 'R-I-239082-132';

const RecommendationSnippet: React.FC<IRecommendationSnippetProps> = ({
    className,
    flags: {idDirectSearchBetweenSnippetsTouch},
}) => (
    <div className={className}>
        <RecommendationWidget
            blockId={idDirectSearchBetweenSnippetsTouch || SNIPPET_WIDGET_ID}
        />
    </div>
);

export default RecommendationSnippet;
