import React, {memo} from 'react';
import B from 'bem-cn-lite';

import {IWithClassName} from '../../interfaces/components/IWithClassName';

import {searchTitle} from '../../lib/meta/searchTitle';
import useSelector from '../useSelector';

const b = B('SearchTitle');

const SearchTitle: React.FC<IWithClassName> = ({className}) => {
    const context = useSelector(state => state.search.context);
    const segments = useSelector(state => state.search.segments);
    const filtering = useSelector(state => state.search.filtering);
    const currencies = useSelector(state => state.currencies);

    const {title, subtitle} = searchTitle({
        context,
        segments,
        filtering,
        currencies,
    });
    const titleElements = title.map((item, index) => (
        <span key={index}>{item}</span>
    ));

    return (
        <header className={b({}, className)}>
            {titleElements}
            {subtitle && (
                <span className={b('subtitle')} data-nosnippet>
                    {' '}
                    {subtitle}
                </span>
            )}
        </header>
    );
};

export default memo(SearchTitle);
