import React, {FC, memo, useMemo} from 'react';
import B from 'bem-cn-lite';

import ITransferSegment from '../../../../interfaces/transfer/ITransferSegment';
import ISearchContext from '../../../../interfaces/state/search/ISearchContext';

import getMinTotalPrice from './utilities/getMinTotalPrice';

import ActionButton from './components/ActionButton/ActionButton';
import Price from '../../../../components/Price/Price';

interface IActionButtonProps {
    subSegments: ITransferSegment[];
    context: ISearchContext;

    className?: string;
}

const b = B('PriceAndActionButton');

const PriceAndActionButton: FC<IActionButtonProps> = props => {
    const {className, subSegments, context} = props;

    const minPrice = useMemo(
        () => getMinTotalPrice(subSegments),
        [subSegments],
    );

    if (!minPrice) {
        return null;
    }

    return (
        <div className={b(undefined, className)}>
            <Price className={b('price')} price={minPrice} round from />

            <ActionButton
                className={b('actionButton')}
                subSegments={subSegments}
                context={context}
            />
        </div>
    );
};

export default memo(PriceAndActionButton);
