import moment from 'moment-timezone';

import {ROBOT, TIME} from '../../../../../../../lib/date/formats';

import ITransferSegment from '../../../../../../../interfaces/transfer/ITransferSegment';

/**
 * Функция возвращает параметры сегмента для формирования ссылки на страницу выбора мест в портале путешествий
 */
export default function getSegmentStringifyParams(
    segment: ITransferSegment,
): string {
    const segmentDepartureMoment = moment.tz(
        segment.departure,
        segment.stationFrom.timezone,
    );

    return `${[
        segment.provider,
        segment.number,
        segment.stationFrom.id,
        segment.stationTo.id,
        segmentDepartureMoment.format(`${ROBOT}T${TIME}`),
    ].join('_')}`;
}
