import ITransferSegment from '../../../../../interfaces/transfer/ITransferSegment';
import ISegmentTariffPriceWithClass from '../../../../../interfaces/segment/ISegmentTariffPriceWithClass';

import getLowestPrice from '../../../../../lib/segments/getLowestPrice';

export default function getMinTotalPrice(
    segments: ITransferSegment[],
): ISegmentTariffPriceWithClass | null {
    return segments
        .map(segment => getLowestPrice(segment))
        .reduce((result, lowestPrice) => {
            if (!result) {
                return null;
            }

            if (!lowestPrice || result.currency !== lowestPrice.currency) {
                return null;
            }

            result.value += lowestPrice.value;

            return result;
        });
}
