import React, {Component} from 'react';
import B from 'bem-cn-lite';
import {momentTimezone as moment} from '../../../../../reexports';

import {humanizeDuration} from '../../../../lib/date/formats';
import checkIsInterline from '../../../../lib/segments/checkIsInterline';
import {getTransferPointDescription} from '../../../../lib/segments/transfer/transferPoint';

import SearchSegment from '../../../SearchSegment/SearchSegment.desktop';

interface ITableSearchTransferSegmentsProps {
    data: any;
    segments: any[];
    opened: boolean;
    withActionButton: boolean;
    withoutPrices?: boolean;
}

const b = B('SearchTransferSegments');

export default class TableSearchTransferSegments extends Component<ITableSearchTransferSegmentsProps> {
    private totalDuration = 0;

    getTransferBlock(segment, nextSegment): React.ReactNode {
        const duration = moment(nextSegment.departure).diff(
            segment.arrival,
            'seconds',
        );

        this.totalDuration += duration;

        return (
            <div className={b('transferBlock')}>
                <div className={b('transferPoint')}>
                    {getTransferPointDescription(segment, nextSegment)}
                </div>

                <div className={b('transferDuration')}>
                    {humanizeDuration(moment.duration(duration, 'seconds'))}
                </div>
            </div>
        );
    }

    getSegmentPosition(count, index): 'first' | 'last' | 'middle' {
        if (index === 0) {
            return 'first';
        }

        if (index === count - 1) {
            return 'last';
        }

        return 'middle';
    }

    render(): React.ReactNode {
        const {
            data,
            opened,
            segments,
            withActionButton = true,
            withoutPrices,
        } = this.props;
        const {segment} = data;
        const segmentsCount = segments.length;
        const isInterline = checkIsInterline(segment);

        this.totalDuration = 0;

        return (
            <td className={b({visible: opened})}>
                {segments.map((transferSegment, index) => {
                    this.totalDuration += transferSegment.duration;

                    const segmentData = {
                        ...data,
                        segment: transferSegment,
                        // Специфичные настройки специально для рейсов с пересадками
                        position: this.getSegmentPosition(segmentsCount, index),
                        totalDuration: humanizeDuration(
                            moment.duration(this.totalDuration, 'seconds'),
                        ),
                        // Общие настройки, предопределнные для рейсов с пересадками
                        // Не теряй при рефакторинге - не будь как Андрей (@ndru)
                        showDepartureDate: true,
                        showArrivalDate: true,
                        isStationsVisible: true,
                        showStops: true,
                        isSegmentOfInterline: isInterline,
                    };

                    return (
                        <div key={index} className={b('segmentHolder')}>
                            <table className={b('table')}>
                                <tbody className={b('tbody')}>
                                    <SearchSegment
                                        key={index}
                                        data={segmentData}
                                        withoutPrices={withoutPrices}
                                        withActionButton={withActionButton}
                                    />
                                </tbody>
                            </table>

                            {index < segmentsCount - 1 &&
                                this.getTransferBlock(
                                    transferSegment,
                                    segments[index + 1],
                                )}
                        </div>
                    );
                })}
            </td>
        );
    }
}
