import React from 'react';
import B from 'bem-cn-lite';
import {Moment} from 'moment';

import {HUMAN_SHORT, TIME} from '../../../../lib/date/formats';

interface ITableSearchTransferTimeProps {
    className?: string;
    timeMoment: Moment;
    showDate: boolean;
}

const b = B('TableSearchTransferTime');

const TableSearchTransferTime: React.FC<ITableSearchTransferTimeProps> = ({
    timeMoment,
    showDate,
    className,
}) => (
    <div className={b({}, className)}>
        {showDate && (
            <div className={b('date')} data-nosnippet>
                {timeMoment.format(HUMAN_SHORT)}
            </div>
        )}

        {timeMoment.format(TIME)}
    </div>
);

export default TableSearchTransferTime;
