import React from 'react';
import B from 'bem-cn-lite';
import {momentTimezone as moment} from '../../../../../reexports';

import ISearchContext from '../../../../interfaces/state/search/ISearchContext';

import {humanizeDuration} from '../../../../lib/date/formats';

import Time from '../Time/Time';
import RailwayTimes from '../../../RailwayTimes/RailwayTimes';

interface ITableSearchTransferTimeAndDurationProps {
    segment: any;
    context: ISearchContext;
    showDepartureDate: boolean;
    showArrivalDate: boolean;
}

const b = B('TableSearchTransferTimeAndDuration');

const TableSearchTransferTimeAndDuration: React.FC<ITableSearchTransferTimeAndDurationProps> =
    ({context, segment, showDepartureDate, showArrivalDate}) => {
        const {duration, transferStations, arrivalMoment, departureMoment} =
            segment;
        const {when} = context;

        return (
            <div className={b()}>
                <div className={b('times')}>
                    <Time
                        className={b('departure')}
                        timeMoment={departureMoment}
                        showDate={showDepartureDate}
                    />

                    <div className={b('duration')}>
                        {humanizeDuration(moment.duration(duration, 'seconds'))}
                    </div>

                    <Time
                        className={b('arrival')}
                        timeMoment={arrivalMoment}
                        showDate={showArrivalDate}
                    />
                </div>

                <RailwayTimes
                    className={b('railwayTimes')}
                    when={when}
                    segment={segment}
                />

                <div className={b('stationsPath')}>{transferStations}</div>
            </div>
        );
    };

export default TableSearchTransferTimeAndDuration;
