import {TRAIN_TYPE} from '../../../lib/transportType';

import ITransferSegment from '../../../interfaces/transfer/ITransferSegment';

export default function needToShowTravelTrainTransferButton(
    segments: ITransferSegment[],
): boolean {
    return (
        segments.length === 2 &&
        segments.every(
            subSegment =>
                subSegment.transport.code === TRAIN_TYPE &&
                (subSegment.tariffClassKeys.length ||
                    subSegment.queryingPrices),
        )
    );
}
