import React from 'react';
import B from 'bem-cn-lite';
import isEmpty from 'lodash/isEmpty';

import ISegment from '../../interfaces/segment/ISegment';
import ISegmentBadges from '../../interfaces/segment/ISegmentBadges';
import ISegmentThreadBase from '../../interfaces/segment/ISegmentThreadBase';

import CanceledSegmentBadge from '../CanceledSegmentBadge/CanceledSegmentBadge.desktop';

import keyset from '../../i18n/badges';

interface ISegmentBadgesProps {
    className?: string;
    badges?: ISegmentBadges;
    cancelType?: ISegment['cancelType'];
    cancelledSegments?: ISegmentThreadBase['cancelledSegments'];
}

const b = B('SegmentBadges');

const SegmentBadges: React.FC<ISegmentBadgesProps> = ({
    className,
    badges,
    cancelType,
    cancelledSegments,
}) => {
    if (cancelType) {
        return (
            <CanceledSegmentBadge
                cancelledSegments={cancelledSegments}
                cancelType={cancelType}
            />
        );
    }

    if (!badges || isEmpty(badges)) {
        return null;
    }

    return (
        <div className={b({isCheapest: badges.cheapest}, className)}>
            {Object.keys(badges).map(badge => (
                <div className={b('badge', {[badge]: true})} key={badge}>
                    {keyset(badge)}
                </div>
            ))}
        </div>
    );
};

export default SegmentBadges;
