import {React, PureComponent, B, mix} from '../base';

import {reachGoalOnce} from '../../lib/yaMetrika';

import Button from '../Button/Button';
import SegmentCalendar from '../search/SegmentCalendar';

import keyset from '../../i18n/segment-date-picker';

const b = B('SegmentDatePicker');

export default class SegmentDatePicker extends PureComponent {
    state = {
        datePickerIsOpened: false,
    };

    onDayClick = () => {
        reachGoalOnce('segment_datepicker_click');
        this.setState({
            datePickerIsOpened: false,
        });
    };

    onDatePickerOpen = () => {
        reachGoalOnce('segment_datepicker_show');
        this.setState({
            datePickerIsOpened: true,
        });
    };

    onDatePickerClose = () => {
        this.setState({
            datePickerIsOpened: false,
        });
    };

    render() {
        const {
            className,

            segment,
            context,

            flags,
            language,
            currencies,

            tariffClassKeys,
        } = this.props;
        const {datePickerIsOpened} = this.state;

        return (
            <div className={mix(b(), className)}>
                <Button
                    className={b('button')}
                    onClick={this.onDatePickerOpen}
                    title={keyset(`button-title-${segment.transport.code}`)}
                >
                    {keyset('button-text')}
                </Button>

                <SegmentCalendar
                    segment={segment}
                    context={context}
                    tariffClassKeys={tariffClassKeys}
                    flags={flags}
                    language={language}
                    currencies={currencies}
                    opened={datePickerIsOpened}
                    onClose={this.onDatePickerClose}
                    onChange={this.onDayClick}
                />
            </div>
        );
    }
}
