import {React, PureComponent, B, mix} from '../base';

import keyset from '../../i18n/time';

import {getRemainingTime} from '../../lib/date/utils';
import getEndpointsData from '../../lib/segments/endpointEvents/getEndpointsData';

import {SUBURBAN_TYPE} from '../../lib/transportType';

const b = B('SegmentInformer');

export default class SegmentInformer extends PureComponent {
    render() {
        const {segment, currentTimeMoment} = this.props;

        if (segment.isInterval) {
            return null;
        }

        const {transport, stationFrom, departureMoment} = segment;
        const endpointsData = getEndpointsData(segment);
        const parts = [];

        if (endpointsData) {
            parts.push(
                <span
                    className={mix(
                        b('item'),
                        b('delay', {
                            attention: endpointsData.isDelay,
                        }),
                    )}
                    key="delay"
                >
                    {endpointsData.text}
                </span>,
            );
        } else if (!segment.runDays && !segment.isGone) {
            const {hours, minutes} = getRemainingTime(
                currentTimeMoment,
                departureMoment,
            );

            if (!hours) {
                // Добавляем приписку об оставшемся до отправления времени

                parts.push(
                    <span className={b('item')} key="remainingTime">
                        {minutes === 0
                            ? keyset('departing-now')
                            : keyset('in-time', {
                                  time: keyset('minutes-short', {
                                      count: minutes,
                                  }),
                              })}
                    </span>,
                );
            }
        }

        // Добавляем приписку с указанием платформы отправления
        if (transport.code === SUBURBAN_TYPE && stationFrom.platform) {
            parts.push(
                <span className={b('item')} key="platform">
                    {stationFrom.platform}
                </span>,
            );
        }

        if (!parts.length) {
            return null;
        }

        return <div className={b()}>{parts}</div>;
    }
}
