import {React, PureComponent, B} from '../base';

const b = B('SegmentPrices');

import Spinner from '../Spinner/Spinner';
import TariffsList from '../TariffsList/TariffsList';
import SegmentActionButton from '../SegmentActionButton/SegmentActionButton.desktop';

export default class SegmentPrices extends PureComponent {
    render() {
        const {
            klass,
            segment,
            queryingPrices,
            tariffClassKeys,
            openPartnerPicker,
            context,
            currencies,
            withActionButton = true,
            className,
        } = this.props;

        const querying = Boolean(
            tariffClassKeys.length === 0 && queryingPrices,
        );

        return (
            <div className={b({}, className)}>
                {!querying && (
                    <>
                        <TariffsList
                            className={b('tariffsList')}
                            segment={segment}
                            tariffClassKeys={tariffClassKeys}
                            context={context}
                            currencies={currencies}
                        />

                        <div className={b('segmentAction')} data-nosnippet>
                            {withActionButton && (
                                <SegmentActionButton
                                    segment={segment}
                                    tariffClassKeys={tariffClassKeys}
                                    tariffClass={klass}
                                    openPartnerPicker={openPartnerPicker}
                                />
                            )}
                        </div>
                    </>
                )}

                {querying && (
                    <Spinner className={b('priceSpinner')} size="tiny" />
                )}
            </div>
        );
    }
}
