import {React, B} from '../base';

import {Moment} from 'moment';

import IMaskDaysOfWalking from '../../interfaces/maskDaysOfWalking/IMaskDaysOfWalking';
import ISegmentDaysByTimezone from '../../interfaces/segment/ISegmentDaysByTimezone';

import {maskToString} from '../../lib/date/stringifyMask';

import segmentKeyset from '../../i18n/segment';

const b = B('SegmentRunDays');

interface ISegmentRunDays {
    isMerged: boolean;

    toDay?: Moment; // Объект начала сегодняшнего дня (moment().startOd('day'))
    timezone?: string;
    runDays?: IMaskDaysOfWalking;
    daysByTimezone?: ISegmentDaysByTimezone;
    className?: string;
}

function SegmentRunDays({
    isMerged,

    toDay,
    timezone,
    runDays,
    daysByTimezone,
    className,
}: ISegmentRunDays): React.ReactElement | null {
    if (!timezone) {
        return null;
    }

    const days = isMerged
        ? runDays && toDay && {text: maskToString(runDays, toDay, timezone)}
        : daysByTimezone && daysByTimezone[timezone];

    if (!days) {
        return null;
    }

    return (
        <div className={b({}, className)}>
            {'schedulePlanAppendix' in days ? (
                <span>
                    {days.shortText}{' '}
                    <span className={b('schedulePlanAppendix')}>
                        {days.schedulePlanAppendix}
                    </span>
                </span>
            ) : (
                <span data-nosnippet>{days.text}</span>
            )}
            {'exceptText' in days && days.exceptText && (
                <div className={b('exceptDays')}>
                    {segmentKeyset('except-days', {days: days.exceptText})}
                </div>
            )}
        </div>
    );
}

export default React.memo(SegmentRunDays);
