import {React, B} from '../base';

import segmentInfoKeyset from '../../i18n/segment-info';

const b = B('SegmentStops');

interface ISegmentStops {
    stops: string;

    className?: string;
    onlyStops?: boolean;
}

export default React.memo(SegmentStops);

function SegmentStops({
    stops,

    className,
    onlyStops = false,
}: ISegmentStops): React.ReactElement {
    return <div className={b({}, className)}>{getText(stops, onlyStops)}</div>;
}

function getText(stops: string, onlyStops: boolean): string {
    switch (stops.toLowerCase()) {
        case 'везде':
            return segmentInfoKeyset('stops-all');
        case 'без остановок':
            return segmentInfoKeyset('stops-express');

        default:
            return onlyStops ? stops : segmentInfoKeyset('stops', {stops});
    }
}
