import {mix} from '../base';

import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';
import {connect} from 'react-redux';

import {
    MODEL,
    DENSITY,
    ETICKET,
    SUBTYPE,
    COMPANY,
    TWO_STOREY,
    TROUGH_TRAIN,
    DELUXE_TRAIN,
    TRAIN_CATEGORY,
    DYNAMIC_PRICING,
    ENDPOINT_EVENT_DATA,
} from '../../lib/segments/transportFeatures/features';

import getFeatureLink from './helpers/getFeatureLink';

import SegmentCompanyLinkUtmContext from '../../contexts/SegmentCompanyLinkUtmContext';
import ETicket from '../basic/bages/ETicket';
import SegmentDynamicPricing from '../basic/bages/SegmentDynamicPricing';

const b = B('SegmentTransport');

const mapStateToProps = ({seoQueryParams, user}) => ({
    seoQueryParams,
    clientId: user.clientId,
});

class SegmentTransport extends PureComponent {
    static contextType = SegmentCompanyLinkUtmContext;

    render() {
        const {features, className, transportType, seoQueryParams, clientId} =
            this.props;
        const {getUtmMedium} = this.context;

        if (!features || !features.length) {
            return null;
        }

        return (
            <div className={mix(b(), className)}>
                {features.map(({type, props = {}, content}) => {
                    const itemClassName = b('item', {[type]: true});

                    switch (type) {
                        case DENSITY:
                            return null;
                        case ETICKET:
                            return (
                                <ETicket
                                    className={mix(itemClassName, b('badge'))}
                                    key={type}
                                    {...props}
                                />
                            );
                        case DYNAMIC_PRICING:
                            return (
                                <SegmentDynamicPricing
                                    className={mix(itemClassName, b('badge'))}
                                    key={type}
                                    {...props}
                                />
                            );
                        case ENDPOINT_EVENT_DATA:
                            return (
                                <span
                                    className={mix(
                                        itemClassName,
                                        b('delay', {
                                            attention: props.isDelay,
                                        }),
                                    )}
                                    key={type}
                                >
                                    {props.text}
                                </span>
                            );
                        case MODEL:
                        case SUBTYPE:
                        case TWO_STOREY:
                        case TROUGH_TRAIN:
                        case TRAIN_CATEGORY:
                            return (
                                <span
                                    className={itemClassName}
                                    key={type}
                                    {...props}
                                >
                                    {content}
                                </span>
                            );
                        case DELUXE_TRAIN:
                        case COMPANY:
                            return getFeatureLink({
                                props: {...props, href: undefined},
                                content,
                                type,
                                className: itemClassName,
                                seoQueryParams,
                                clientId,
                                utmMedium: getUtmMedium(transportType),
                            });

                        default:
                            return content;
                    }
                })}
            </div>
        );
    }
}

export default connect(mapStateToProps)(SegmentTransport);
