import {React, PureComponent, B, mix} from '../base';

import getFeatureLink from './helpers/getFeatureLink';

import {
    MODEL,
    ETICKET,
    SUBTYPE,
    COMPANY,
    DENSITY,
    TWO_STOREY,
    TROUGH_TRAIN,
    DELUXE_TRAIN,
    TRAIN_CATEGORY,
    DYNAMIC_PRICING,
    ENDPOINT_EVENT_DATA,
} from '../../lib/segments/transportFeatures/features';

const b = B('SegmentTransport');

export default class SegmentTransport extends PureComponent {
    getFeatures() {
        const {features} = this.props;

        return features
            .map(({type, props = {}, content}) => {
                const itemClassName = b('item', {[type]: true});

                switch (type) {
                    case ETICKET:
                    case DYNAMIC_PRICING:
                    case ENDPOINT_EVENT_DATA:
                        return null;
                    case MODEL:
                    case DENSITY:
                    case SUBTYPE:
                    case TWO_STOREY:
                    case TROUGH_TRAIN:
                    case TRAIN_CATEGORY:
                        return (
                            <span
                                className={itemClassName}
                                {...props}
                                key={type}
                            >
                                {content}
                            </span>
                        );
                    case DELUXE_TRAIN:
                    case COMPANY:
                        return getFeatureLink({
                            props,
                            content,
                            type,
                            className: itemClassName,
                        });

                    default:
                        return content;
                }
            })
            .filter(Boolean);
    }

    render() {
        const {className} = this.props;

        const features = this.getFeatures(this.props.features);

        if (!features || !features.length) {
            return null;
        }

        return <div className={mix(b(), className)}>{features}</div>;
    }
}
