import {React} from '../../base';

import applyUtm from '../../../lib/url/applyUtm';

import Link from '../../Link';

export default function getFeatureLink({
    props,
    content,
    type,
    className,
    seoQueryParams,
    clientId,
    utmMedium,
}) {
    const Wrapper = props.href ? Link : 'span';
    const href = props.href
        ? applyUtm(props.href, seoQueryParams, clientId, utmMedium)
        : undefined;

    return (
        <Wrapper {...props} className={className} key={type} href={href}>
            {content}
        </Wrapper>
    );
}
