import React, {ReactElement, memo} from 'react';
import B from 'bem-cn-lite';

import Platform from '../../interfaces/Platform';
import IconGlyph from '../../interfaces/components/IconGlyph';

import {buildSearchDescription} from '../../lib/seo/search';
import gatherMinPriceData from '../../lib/segments/gatherMinPriceData';
import isLastochka from '../../lib/segments/isLastochka';
import isLastochkaPage from '../../lib/search/isLastochkaPage';
import useSelector from '../useSelector';

import Icon from '../Icon/Icon';

const b = B('ServiceDescription');

export default memo(ServiceDescription);

function ServiceDescription(): ReactElement {
    const context = useSelector(state => state.search.context);
    const segments = useSelector(state => state.search.segments);
    const transportTypes = useSelector(state => state.search.transportTypes);
    const filtering = useSelector(state => state.search.filtering);
    const language = useSelector(state => state.language);
    const archivalData = useSelector(state => state.search.archivalData);

    const segmentsForDescription = isLastochkaPage(
        context.transportType,
        context.when,
        filtering,
    )
        ? segments.filter(isLastochka)
        : segments;
    const minPriceData = gatherMinPriceData(segmentsForDescription);

    const {title, text} = buildSearchDescription({
        context,
        segments: segmentsForDescription,
        language,
        transportTypes: archivalData?.transportTypes ?? transportTypes,
        filtering,
        minPriceData,
        archivalData,
    });

    return (
        <div
            className={b({
                platform: process.env.PLATFORM,
                archivalData:
                    Boolean(archivalData) &&
                    process.env.PLATFORM === Platform.mobile,
            })}
        >
            {!archivalData && (
                <Icon
                    className={b('icon')}
                    glyph={IconGlyph.serviceDescription}
                />
            )}

            <div className={b('content')}>
                <h2 className={b('title')}>{title}</h2>
                <p className={b('text')}>{text}</p>
            </div>
        </div>
    );
}
