import {React, B} from '../base';

const b = B('Spinner');

interface ISpinner {
    className?: string;
    size?: 'tiny' | 'small' | 'normal' | 'large';
    color?: 'gray';
}

export default React.memo(Spinner);

function Spinner({className, size, color}: ISpinner): React.ReactElement {
    return <span className={b({size, color}, className)} />;
}
