import {connect} from 'react-redux';
import React, {SyntheticEvent} from 'react';
import {Moment} from 'moment';

import {ROBOT} from '../../lib/date/formats';

import Lang from '../../interfaces/Lang';
import Tld from '../../interfaces/Tld';
import MapStateToProps from '../../interfaces/MapStateToProps';
import IRange from '../../interfaces/date/IRange';
import DateRobot from '../../interfaces/date/DateRobot';
import IStateStation from '../../interfaces/state/station/IStateStation';

import CalendarDayLink from '../CalendarDayLink';
import CalendarDayBase from '../CalendarDay/CalendarDayBase';

import {stationUrl} from '../../lib/url/stationUrl';

interface IStationCalendarDayLinkStateToProps {
    language: Lang;
    tld: Tld;
    station: IStateStation;
}

interface IStationCalendarDayLinkProps
    extends IStationCalendarDayLinkStateToProps {
    day: Moment;
    today: Moment;
    dateStart: Moment;
    range: IRange;
    onClick: (e: SyntheticEvent) => void;

    value?: {date?: DateRobot};
}

const mapStateToProps: MapStateToProps<IStationCalendarDayLinkStateToProps> = ({
    tld,
    language,
    station,
}) => ({
    tld,
    language,
    station,
});

class StationCalendarDayLink extends CalendarDayBase<
    IStationCalendarDayLinkProps,
    {}
> {
    render(): React.ReactElement {
        const {day, today, range, value, onClick, station, language, tld} =
            this.props;

        const {
            id,
            type,
            event,
            directionCode,
            currentSubtype,
            mainSubtype,
            terminalName,
            time,
        } = station;

        const selectedDay = day.format(ROBOT) as DateRobot;
        const href = stationUrl({
            id,
            subtype: currentSubtype,
            mainSubtype,
            event,
            direction: directionCode,
            terminalName,
            type,
            language,
            tld,
            time,
            date: selectedDay,
        });
        const isInactive = this.isInactive({day, range});
        const selected = selectedDay === value?.date;

        return (
            <CalendarDayLink
                day={day}
                today={today}
                href={isInactive ? undefined : href}
                inactive={isInactive}
                onClick={onClick}
                selected={selected}
                colorless
            />
        );
    }
}

export default connect(mapStateToProps)(StationCalendarDayLink);
