import AllThreadType from '../../interfaces/state/station/AllThreadType';
import AllStationInformerScheduleThreadType from '../../interfaces/components/informer/AllStationInformerScheduleThreadType';

import getDateRobotFromDateMoment from '../../lib/date/getDateRobotFromDateMoment';

/*
    Добавлять дату нужно в следующих случаях:
    - в первом сниппете
    - если это первый сниппет с новой датой

    Также если это сниппеты аэропорта или жд, то еще в случае:
    - если у планового и фактического времени отличаются даты (1:00 следующего дня вместо 23:30 предыдущего)
*/
function needShowDate(
    thread: AllThreadType | AllStationInformerScheduleThreadType,
    prevThread?: AllThreadType | AllStationInformerScheduleThreadType,
): boolean {
    if (!prevThread) {
        return true;
    }

    const date =
        'departureFrom' in thread && thread.departureFrom
            ? getDateRobotFromDateMoment(thread.departureFrom)
            : 'date' in thread
            ? thread.date
            : 'eventDt' in thread && thread.eventDt.datetime
            ? getDateRobotFromDateMoment(thread.eventDt.datetime)
            : undefined;

    const prevDate =
        'departureFrom' in prevThread && prevThread.departureFrom
            ? getDateRobotFromDateMoment(prevThread.departureFrom)
            : 'date' in prevThread
            ? prevThread.date
            : 'eventDt' in prevThread && prevThread.eventDt.datetime
            ? getDateRobotFromDateMoment(prevThread.eventDt.datetime)
            : undefined;

    if (date && prevDate && date !== prevDate) {
        return true;
    }

    const actualDate =
        'status' in thread && thread.status?.actualDt
            ? getDateRobotFromDateMoment(thread.status.actualDt)
            : 'eventDt' in thread && thread.eventDt.datetime
            ? getDateRobotFromDateMoment(thread.eventDt.datetime)
            : undefined;

    if (date && actualDate && date !== actualDate) {
        return true;
    }

    return false;
}

export default needShowDate;
