import React, {memo} from 'react';
import B from 'bem-cn-lite';

import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';
import StationType from '../../interfaces/state/station/StationType';
import InformerColor from '../../interfaces/components/informer/InformerColor';
import InformerTheme from '../../interfaces/components/informer/InformerTheme';
import StationEventList from '../../interfaces/state/station/StationEventList';
import StationInformerType from '../../interfaces/components/informer/StationInformerType';

import getStationInformerUrl from '../../lib/url/getStationInformerUrl';

import Link from '../Link';

const b = B('StationInformerDirectionTabs');

import stationKeyset from '../../i18n/station';

interface IGetTabParams {
    event: StationEventList;
    title: string;
    href: string;

    selected?: boolean;
}

function getTab({
    event,
    title,
    href,

    selected,
}: IGetTabParams): React.ReactElement {
    return selected ? (
        <div className={b(event, {selected})}>{title}</div>
    ) : (
        <Link className={b(event)} href={href}>
            {title}
        </Link>
    );
}

interface IStationInformerDirectionTabsParams {
    id: number;
    tld: Tld;
    language: Lang;
    type: StationType;
    size: number;
    event: StationEventList;

    isMobile?: boolean;
    color?: InformerColor;
    theme?: InformerTheme;
    informerType?: StationInformerType;
}

export default memo(StationInformerDirectionTabs);

function StationInformerDirectionTabs({
    id,
    tld,
    language,
    type,
    size,
    event,

    isMobile,
    color,
    theme,
    informerType,
}: IStationInformerDirectionTabsParams): React.ReactElement {
    const depatureTitle =
        type === StationType.plane
            ? stationKeyset('departure-plane')
            : stationKeyset('departure');
    const arrivalTitle =
        type === StationType.plane
            ? stationKeyset('arrival-plane')
            : stationKeyset('arrival');

    const isScheduleType =
        type === StationType.bus || type === StationType.water;

    const stationUrlParams = {
        id,
        tld,
        language,

        size,
        type: informerType,
        color,
        theme,
    };

    return (
        <div className={b({color, isMobile, theme})}>
            {getTab({
                event: StationEventList.departure,
                title: depatureTitle,
                href: getStationInformerUrl({
                    ...stationUrlParams,
                    event: StationEventList.departure,
                }),
                selected:
                    isScheduleType || event === StationEventList.departure,
            })}

            {!isScheduleType &&
                getTab({
                    event: StationEventList.arrival,
                    title: arrivalTitle,
                    href: getStationInformerUrl({
                        ...stationUrlParams,
                        event: StationEventList.arrival,
                    }),
                    selected: event === StationEventList.arrival,
                })}

            <div className={b('border')} />
        </div>
    );
}
