import IThreadRailroad from '../../interfaces/state/station/IThreadRailroad';

import getDateRobotFromDateMoment from '../../lib/date/getDateRobotFromDateMoment';

// Определяет нужно ли зачеркивать дату отправления по расписанию
export default function needChangeDateForRailroadThread(
    thread: IThreadRailroad,
): boolean {
    const {
        departureFrom,
        eventDt: {datetime},
    } = thread;

    if (
        departureFrom &&
        datetime &&
        getDateRobotFromDateMoment(departureFrom) !==
            getDateRobotFromDateMoment(datetime)
    ) {
        return true;
    }

    return false;
}
