import React, {memo, ReactElement} from 'react';
import B from 'bem-cn-lite';

import InformerColor from '../../interfaces/components/informer/InformerColor';

import informerKeyset from '../../i18n/informers';

const b = B('StationInformerTable');

interface IStationInformerTableParams {
    rows: ReactElement[];
    size: number;

    isMobile?: boolean;
    colSpan?: number; // Количество столбцов в таблице
    color?: InformerColor;
}

export default memo(StationInformerTable);

function StationInformerTable({
    rows,
    size,

    isMobile = false,
    colSpan = 1,
    color,
}: IStationInformerTableParams): React.ReactElement | null {
    const emptyRows: null[] =
        size && rows.length < size ? Array(size - rows.length).fill(null) : [];

    return (
        <table className={b({isMobile, color})}>
            <tbody className={b('body')}>
                {Boolean(rows.length) &&
                    rows.map(row => {
                        return row;
                    })}

                {emptyRows.map((e, index) => (
                    <tr className={b('row', {empty: true})} key={index}>
                        <td colSpan={colSpan}>
                            {Boolean(!rows.length && index === 0) &&
                                informerKeyset('no-threads')}
                        </td>
                    </tr>
                ))}
            </tbody>
        </table>
    );
}
