import StationSubtype from '../../../interfaces/state/station/StationSubtype';

import stationKeyset from '../../../i18n/station';

export default function getTitle(subtype: StationSubtype): string {
    switch (subtype) {
        case StationSubtype.suburban:
            return stationKeyset('page-subtype-suburban');
        case StationSubtype.train:
            return stationKeyset('page-subtype-train');
        case StationSubtype.tablo:
            return stationKeyset('page-subtype-tablo');

        default:
            return '';
    }
}
