import React, {memo, ReactElement} from 'react';
import B from 'bem-cn-lite';

import StationSubtype from '../../../interfaces/state/station/StationSubtype';
import StationType from '../../../interfaces/state/station/StationType';
import DateRobot from '../../../interfaces/date/DateRobot';
import StationDateSpecialValue from '../../../interfaces/date/StationDateSpecialValue';
import StationEventList from '../../../interfaces/state/station/StationEventList';
import Platform from '../../../interfaces/Platform';

import {stationUrl} from '../../../lib/url/stationUrl';
import {reachGoal} from '../../../lib/yaMetrika';
import useSelector from '../../useSelector';

import Link from '../../Link';

import stationKeyset from '../../../i18n/station';

const b = B('PlaneDirectionTabs');

const isMobile = process.env.PLATFORM === Platform.mobile;

interface IPlaneDirectionTabs {
    stationId: number;
    currentSubtype: StationSubtype;
    type: StationType;
    event: StationEventList;
    terminalName: string;

    className?: string;
    mainSubtype?: StationSubtype;
    date?: DateRobot;
    special?: StationDateSpecialValue;
}

export default memo(PlaneDirectionTabs);

function onDirectionLinkClick(): void {
    reachGoal('station_direction_click');
}

function PlaneDirectionTabs({
    stationId,
    currentSubtype,
    type,
    event,
    terminalName,

    className,
    mainSubtype,
    date,
    special,
}: IPlaneDirectionTabs): ReactElement {
    const tld = useSelector(state => state.tld);
    const language = useSelector(state => state.language);

    const eventsInTabs = [StationEventList.departure, StationEventList.arrival];
    const eventsElements = eventsInTabs.map(
        (eventForTab): React.ReactElement => {
            const active = eventForTab === event;
            const url = active
                ? undefined
                : stationUrl({
                      id: stationId,
                      tld,
                      language,
                      type,
                      subtype: currentSubtype,
                      mainSubtype,
                      isMobile,
                      date,
                      special,
                      event: eventForTab,
                      terminalName,
                  });
            let title: string;

            switch (eventForTab) {
                case StationEventList.departure:
                    title = stationKeyset('departure-plane');
                    break;
                case StationEventList.arrival:
                    title = stationKeyset('arrival-plane');
                    break;
            }

            return (
                <span className={b('tab', {active})} key={eventForTab}>
                    {url ? (
                        <Link
                            href={url}
                            className="tabLink"
                            onClick={onDirectionLinkClick}
                        >
                            {title}
                        </Link>
                    ) : (
                        title
                    )}
                </span>
            );
        },
    );

    return <div className={b({}, className)}>{eventsElements}</div>;
}
