import {CHAR_MIDDLE_DASH} from '../../../lib/stringUtils';

import StationTime from '../../../interfaces/state/station/StationTime';
import TimeOption from './interfaces/TimeOption';

import stationKeyset from '../../../i18n/station';

export default function formatTitleTimes(option?: TimeOption): string {
    if (!option) {
        return stationKeyset('time');
    }

    if (option.value === StationTime.all) {
        return stationKeyset('all-times');
    }

    return option.value.replace('-', ` ${CHAR_MIDDLE_DASH} `);
}
