import TerminalOption from './interfaces/TerminalOption';
import ITerminal from '../../../interfaces/state/station/ITerminal';

import stationKeyset from '../../../i18n/station';

export default function getTerminalOptions(
    terminals: ITerminal[],
): TerminalOption[] {
    if (!terminals.length) {
        return [];
    }

    return [
        {
            value: '',
            title: stationKeyset('all-terminals'),
        },
    ].concat(...terminals.map(({name}) => ({value: name, title: name})));
}
