import {CHAR_MIDDLE_DASH} from '../../../lib/stringUtils';

import StationTime from '../../../interfaces/state/station/StationTime';
import TimeOption from './interfaces/TimeOption';

import stationKeyset from '../../../i18n/station';

const timeOptions: TimeOption[] = Object.values(StationTime)
    .reduce<TimeOption[]>((result, value) => {
        if (value === StationTime.all) {
            return result;
        }

        result.push({
            title: value.replace('-', ` ${CHAR_MIDDLE_DASH} `),
            value,
        });

        return result;
    }, [])
    .sort((a, b) => {
        if (a.value > b.value) {
            return 1;
        }

        if (a.value < b.value) {
            return -1;
        }

        return 0;
    });

timeOptions.unshift({
    title: stationKeyset('all-times'),
    value: StationTime.all,
});

export default timeOptions;
