import ICodeshare from '../../../interfaces/state/station/ICodeshare';
import IStationCompany from '../../../interfaces/state/station/IStationCompany';
import StationCompaniesById from '../../../interfaces/state/station/StationCompaniesById';

import getCompany from '../../../lib/station/getCompany';

interface IFormattedCompanies {
    companyId: number;
    number: string;
    numberLetters: string;
    numberNumeral: string;

    company?: IStationCompany;
}

export default function formatCompanies(
    companyId: number,
    number: string,
    companiesById: StationCompaniesById,
    codeshares?: ICodeshare[],
): IFormattedCompanies[] {
    return [{companyId, number}, ...(codeshares || [])].map(flight => {
        const company = getCompany(flight.companyId, companiesById);
        const [numberLetters, numberNumeral] = flight.number.split(' ');

        return {
            companyId: flight.companyId,
            number: flight.number,
            company,
            numberLetters,
            numberNumeral,
        };
    });
}
