import {makeCacheable} from '../../../lib/cache';
import {reachGoal} from '../../../lib/yaMetrika';

const getOnThreadRowClick = makeCacheable(
    (aviaLink: string, isMobile: boolean) => (): void => {
        if (isMobile) {
            reachGoal('flight_number_click_mobile');
        } else {
            reachGoal('flight_number_click_desktop');
        }

        window.open(aviaLink, '_blank');
    },
);

export default getOnThreadRowClick;
