import IStationThreadStatus from '../../../interfaces/state/station/IStationThreadStatus';
import ThreadStatus from '../../../interfaces/state/station/ThreadStatus';
import StationEventList from '../../../interfaces/state/station/StationEventList';

// Проверяет нужно ли окрашивать в красный информацию о фактическом времени вылета/прилета
export default function threadTimeChangeIsAlert(
    event: StationEventList,
    status: IStationThreadStatus | null,
    minutesBetweenEventDtAndActualDt: number | null,
): boolean {
    if (!status) {
        return false;
    }

    const {status: threadStatus, diverted} = status;

    // Рейс отменен
    if (threadStatus === ThreadStatus.cancelled) {
        return true;
    }

    // Рейс направлен в другой аэропорт
    if (diverted) {
        return true;
    }

    // Прилет/вылет рейса ожидается позже запланированного
    if (
        threadStatus === ThreadStatus.delayed &&
        minutesBetweenEventDtAndActualDt !== null &&
        minutesBetweenEventDtAndActualDt <= -5
    ) {
        return true;
    }

    // Самолет прилетел позже запланированного
    if (
        event === StationEventList.arrival &&
        threadStatus === ThreadStatus.arrived &&
        minutesBetweenEventDtAndActualDt !== null &&
        minutesBetweenEventDtAndActualDt <= -5
    ) {
        return true;
    }

    // Самолет вылетает раньше
    if (
        event === StationEventList.departure &&
        threadStatus === ThreadStatus.early &&
        minutesBetweenEventDtAndActualDt !== null &&
        minutesBetweenEventDtAndActualDt >= 30
    ) {
        return true;
    }

    return false;
}
