import IStationThreadStatus from '../../../interfaces/state/station/IStationThreadStatus';
import ThreadStatus from '../../../interfaces/state/station/ThreadStatus';

// Проверяет нужно ли зачеркивать время вылета/прилета по расписанию
export default function threadTimeIsNotActual(
    status: IStationThreadStatus | null,
    minutesBetweenEventDtAndActualDt: number | null,
): boolean {
    if (!status) {
        return false;
    }

    const {status: statusValue} = status;

    return (
        (statusValue === ThreadStatus.delayed ||
            statusValue === ThreadStatus.arrived ||
            statusValue === ThreadStatus.early) &&
        minutesBetweenEventDtAndActualDt !== null &&
        minutesBetweenEventDtAndActualDt !== 0
    );
}
