import StationSubtype from '../../../interfaces/state/station/StationSubtype';
import StationEventList from '../../../interfaces/state/station/StationEventList';

import stationKeyset from '../../../i18n/station';

export default function getShowGoneThreadsButtonText(
    goneThreadsAreOpened: boolean,
    event: StationEventList,
    countGone: number,
    currentSubtype: StationSubtype | null,
): string {
    const keysetParams = {count: countGone};
    const isDeparture = event === StationEventList.departure;

    if (goneThreadsAreOpened) {
        switch (currentSubtype) {
            case StationSubtype.train:
            case StationSubtype.tablo:
                return isDeparture
                    ? stationKeyset('hide-gone-train', keysetParams)
                    : stationKeyset('hide-gone-train-arrival', keysetParams);
            case StationSubtype.suburban:
                return isDeparture
                    ? stationKeyset('hide-gone-suburban', keysetParams)
                    : stationKeyset('hide-gone-suburban-arrival', keysetParams);

            default:
                return isDeparture
                    ? stationKeyset('hide-gone', keysetParams)
                    : stationKeyset('hide-gone-arrival', keysetParams);
        }
    } else {
        switch (currentSubtype) {
            case StationSubtype.train:
            case StationSubtype.tablo:
                return isDeparture
                    ? stationKeyset('show-gone-train', keysetParams)
                    : stationKeyset('show-gone-train-arrival', keysetParams);
            case StationSubtype.suburban:
                return isDeparture
                    ? stationKeyset('show-gone-suburban', keysetParams)
                    : stationKeyset('show-gone-suburban-arrival', keysetParams);

            default:
                return isDeparture
                    ? stationKeyset('show-gone', keysetParams)
                    : stationKeyset('show-gone-arrival', keysetParams);
        }
    }
}
