import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';
import {connect} from 'react-redux';

import Dispatch from '../../../interfaces/actions/Dispatch';
import IconGlyph from '../../../interfaces/components/IconGlyph';

import {reachGoal} from '../../../lib/yaMetrika';

import {setTeaserIsOpened} from '../../../actions/station';

import Icon from '../../Icon/Icon';

const b = B('StationTeaser');

interface IStationTeaserProps {
    title: string;
    content: string;
    mobileContent: string | null;
    dispatch: Dispatch;
    id: number;

    isOpened?: boolean;
    className?: string;
}

class StationTeaser extends PureComponent<IStationTeaserProps, {}> {
    onToggleDetails = (): void => {
        const {dispatch, id, isOpened} = this.props;

        reachGoal(`station_teaser_${isOpened ? 'closed' : 'opened'}`);
        dispatch(setTeaserIsOpened({id, isOpened: !isOpened}));
    };

    render(): React.ReactElement {
        const {title, className, content, mobileContent, isOpened} = this.props;

        const alwaysOpened =
            !mobileContent || content.trim() === mobileContent.trim();

        const html = isOpened || alwaysOpened ? content : `${mobileContent}...`;

        return (
            <div className={b({isOpened: alwaysOpened || isOpened}, className)}>
                <div className={b('header')}>
                    <span
                        className={b('title')}
                        dangerouslySetInnerHTML={{
                            __html: title,
                        }}
                    />

                    {!alwaysOpened && (
                        <Icon
                            className={b('shrinkIcon')}
                            glyph={IconGlyph.arrowDown}
                            onClick={this.onToggleDetails}
                        />
                    )}
                </div>

                <div
                    className={b('content')}
                    dangerouslySetInnerHTML={{
                        __html: html,
                    }}
                />
            </div>
        );
    }
}

export default connect()(StationTeaser);
