import React, {memo, ReactElement, useCallback} from 'react';
import B from 'bem-cn-lite';

import IconGlyph from '../../../interfaces/components/IconGlyph';

import useDispatch from '../../useDispatch';
import {clearMarkup} from '../../../lib/stringUtils';
import {reachGoal} from '../../../lib/yaMetrika';

import {setTeaserIsOpened} from '../../../actions/station';

import Icon from '../../Icon/Icon';

const b = B('StationTeaser');

interface IStationTeaser {
    title: string;
    content: string;
    mobileContent: string | null;
    id: number;

    isOpened?: boolean;
    className?: string;
}

export default memo(stationTeaser);

function stationTeaser({
    title,
    content,
    mobileContent,
    id,
    isOpened,

    className,
}: IStationTeaser): ReactElement {
    const dispatch = useDispatch();

    const onClick = useCallback(() => {
        reachGoal(`station_teaser_${isOpened ? 'closed' : 'opened'}`);
        dispatch(setTeaserIsOpened({id, isOpened: !isOpened}));
    }, [dispatch, id, isOpened]);

    const alwaysOpened =
        !mobileContent || content.trim() === mobileContent.trim();

    const html = isOpened || alwaysOpened ? content : `${mobileContent}...`;

    return (
        <div
            className={b({isOpened: alwaysOpened || isOpened}, className)}
            onClick={onClick}
        >
            <div className={b('header')}>
                <span className={b('headerText')}>{clearMarkup(title)}</span>

                {!alwaysOpened && (
                    <Icon
                        className={b('headerIcon')}
                        glyph={IconGlyph.arrowUpBold}
                    />
                )}
            </div>

            <div
                className={b('content')}
                dangerouslySetInnerHTML={{__html: html}}
            />
        </div>
    );
}
