import moment from 'moment';

import StationDateSpecialValue from '../../interfaces/date/StationDateSpecialValue';
import StationEventList from '../../interfaces/state/station/StationEventList';
import StationType from '../../interfaces/state/station/StationType';
import DateRobot from '../../interfaces/date/DateRobot';

import {HUMAN} from '../../lib/date/formats';

import stationKeyset from '../../i18n/station';

export default function getWhenDateText(
    type: StationType,
    event: StationEventList,
    whenDate?: DateRobot,
    whenSpecial?: StationDateSpecialValue,
    isMobile?: boolean,
): string | null {
    if (whenSpecial === StationDateSpecialValue.allDays) {
        return null;
    }

    if (!whenDate) {
        return null;
    }

    const whenDateMomwnt = moment(whenDate);

    const formattedDate = whenDateMomwnt.format(HUMAN).toLowerCase();
    const dayOfWeek = whenDateMomwnt.format('dddd');

    if (isMobile) {
        if (event === StationEventList.arrival) {
            if (type === StationType.railroad) {
                return stationKeyset('date-mobile-arrival-train', {
                    date: formattedDate,
                    dayOfWeek,
                });
            }

            if (type === StationType.plane) {
                return stationKeyset('date-mobile-arrival-plane', {
                    date: formattedDate,
                    dayOfWeek,
                });
            }
        }

        if (event === StationEventList.departure) {
            if (type === StationType.railroad) {
                return stationKeyset('date-mobile-departure-train', {
                    date: formattedDate,
                    dayOfWeek,
                });
            }

            if (type === StationType.plane) {
                return stationKeyset('date-mobile-departure-plane', {
                    date: formattedDate,
                    dayOfWeek,
                });
            }
        }

        if (type === StationType.bus || type === StationType.water) {
            return stationKeyset('date-mobile-departure-bus', {
                date: formattedDate,
                dayOfWeek,
            });
        }

        return null;
    }

    return `${formattedDate}, ${dayOfWeek}`;
}
