import React, {ReactElement, memo} from 'react';
import B from 'bem-cn-lite';

import {CHAR_NBSP} from '../../lib/stringUtils';

import ExceptString from '../ExceptString/ExceptString';

import stationKeyset from '../../i18n/station';

const b = B('StationRunDays');

const regexpForDots = /\s+(…|\.+)$/;

function replaceSpaceBeforeDots(str: string): string {
    return str.replace(regexpForDots, `${CHAR_NBSP}$1`);
}

interface IStationRunDays {
    daysText: string | null; // Полная строка с днями хождения, может отсутствовать, если указаны runDaysText
    runDaysText: string | null; // Строка дней, когда нитка точно ходит, имеет приоритет над daysText
    exceptDaysText: string | null; // Строка исключения дней хождения. Работает вместе с runDaysText. Может отсутствовать, если нет исключаемых дней или используется daysText. Слово "кроме" в строку не включено.

    fontWeightForExcept?: 'normal' | 'bold';
    className?: string;
}

export default memo(StationRunDays);

function StationRunDays({
    daysText,
    runDaysText,
    exceptDaysText,

    fontWeightForExcept,
    className,
}: IStationRunDays): ReactElement | null {
    return exceptDaysText ? (
        <span className={b({fontWeightForExcept}, className)}>
            {`${runDaysText}, `}
            <span className={b('except')}>
                {`${stationKeyset('except')} ${replaceSpaceBeforeDots(
                    exceptDaysText,
                )}`}
            </span>
        </span>
    ) : daysText ? (
        <ExceptString
            text={replaceSpaceBeforeDots(daysText)}
            fontWeightForExcept={fontWeightForExcept}
        />
    ) : null;
}
