import React, {memo, ReactElement} from 'react';
import B from 'bem-cn-lite';

import IStationScheduleThread from '../../interfaces/state/station/IStationScheduleThread';
import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';

import getTimeFromDateMoment from '../../lib/date/getTimeFromDateMoment';
import getThreadUrl from '../../lib/url/getThreadUrl';
import getDateRobotFromDateMoment from '../../lib/date/getDateRobotFromDateMoment';

import Link from '../Link';

const b = B('StationThreadLink');

interface IStationThreadLink {
    thread: IStationScheduleThread;
    tld: Tld;
    language: Lang;
    stationFromId: number;

    className?: string;
    prevThread?: IStationScheduleThread; // Для выделения жирным ссылки в столбце с переходом на следкющий час
}

export default memo(StationThreadLink);

function StationThreadLink({
    thread,
    tld,
    language,
    stationFromId,

    className,
    prevThread,
}: IStationThreadLink): ReactElement {
    const {canonicalUid, departureFrom} = thread;

    const time = getTimeFromDateMoment(departureFrom);
    const departureFromDateRobot = getDateRobotFromDateMoment(departureFrom);
    const bold =
        prevThread &&
        getTimeFromDateMoment(prevThread.departureFrom)?.split(':')[0] !==
            time?.split(':')[0];

    const url = getThreadUrl({
        canonicalUid,
        tld,
        language,
        stationFromId,
        departureFromDateRobot,
    });

    return (
        <Link className={b({bold}, className)} href={url}>
            {time}
        </Link>
    );
}
