import React, {memo} from 'react';
import B from 'bem-cn-lite';

import {TRANSPORT_TYPES_WITH_DISPLAYED_STATIONS} from '../../lib/transportType';

import IStationGroup from '../../interfaces/state/stationsGroup/IStationGroup';

import StationsGroup from '../StationsGroup/StationsGroup.mobile';

const b = B('Stations');

interface IStationsParams {
    stationsGroup: IStationGroup[];

    cityId?: number;
}

export default memo(Stations);

function Stations({
    stationsGroup,

    cityId,
}: IStationsParams): React.ReactElement {
    return (
        <ul className={b()}>
            {stationsGroup
                .filter(group =>
                    TRANSPORT_TYPES_WITH_DISPLAYED_STATIONS.includes(
                        group.t_type,
                    ),
                )
                .map(group => (
                    <StationsGroup
                        group={group}
                        key={group.t_type}
                        cityId={cityId}
                    />
                ))}
        </ul>
    );
}
