import hasStatus from './hasStatus';

import IStation from '../../interfaces/state/stationsGroup/IStation';

import stationsGroupKeyset from '../../i18n/bt-lib-stations';

export default function getStatusText(station: IStation): string | null {
    if (!hasStatus(station)) {
        return null;
    }

    const {t_type: type, status} = station;
    const {late, cancelled} = status;
    let key = `status-${type}`;

    if (late) {
        key += '-late';
    }

    if (cancelled) {
        key += '-cancelled';
    }

    return stationsGroupKeyset(key, {late, cancelled});
}
