import {React, B} from '../base';

import ISegmentFacility from '../../interfaces/segment/ISegmentFacility';

import FacilityIcon from '../FacilityIcon/FacilityIcon';

const b = B('SuburbanFacilities');

interface ISuburbanFacilities {
    suburbanFacilities: ISegmentFacility[];

    expanded?: boolean; // Отображение в виде списка с расшифровками иконок
    className?: string;
    iconClassName?: string;
}

function SuburbanFacilities({
    suburbanFacilities,
    expanded = false,
    className,
    iconClassName,
}: ISuburbanFacilities): React.ReactElement {
    return (
        <ul className={b({expanded}, className)}>
            {suburbanFacilities.map(item => (
                <li
                    className={b('item')}
                    key={item.code}
                    aria-label={item.title}
                >
                    <FacilityIcon {...item} className={iconClassName} />

                    {expanded && (
                        <span className={b('title')}>{item.title}</span>
                    )}
                </li>
            ))}
        </ul>
    );
}

export default React.memo(SuburbanFacilities);
