import {React, PureComponent, B, mix} from '../base';

import SecondaryPosition from '../../interfaces/lib/dimensions/SecondaryPosition';
import PrimaryPosition from '../../interfaces/lib/dimensions/PrimaryPosition';

import {reachGoalOnce} from '../../lib/yaMetrika';

import Dropdown from '../Dropdown/Dropdown';
import SuburbanTariffsCategories from '../SuburbanTariffsCategories/SuburbanTariffsCategories';

import commonKeyset from '../../i18n/common/index';

const b = B('SuburbanTariffs');

export default class SuburbanTariffs extends PureComponent {
    componentDidMount() {
        reachGoalOnce('suburban_tariffs_exist');
    }

    onDropdownOpen() {
        reachGoalOnce('suburban_tariffs_show');
    }

    render() {
        const {className, tariffs, currencies} = this.props;

        const {suburbanCategories} = tariffs;

        return (
            <Dropdown
                className={mix(b(), className)}
                buttonText={commonKeyset('all-prices')}
                onOpen={this.onDropdownOpen}
                popupPositions={[
                    [PrimaryPosition.bottom, SecondaryPosition.right],
                    [PrimaryPosition.right, SecondaryPosition.center],
                    [PrimaryPosition.top, SecondaryPosition.right],
                    [PrimaryPosition.left, SecondaryPosition.center],
                ]}
            >
                <SuburbanTariffsCategories
                    className={b('categories')}
                    categories={suburbanCategories}
                    currencies={currencies}
                />
            </Dropdown>
        );
    }
}
